--Order of Battle - Aircraft/Helicopter
--organized in units (squadrons/regiments) containing a number of aircraft
--Campaign Version-V2.00
--[[ Unit Entry Example ----------------------------------------------------------------------------

[1] = {
	inactive = true,								--true if unit is not active
	player = true,									--true for player unit
	name = "527 TFS",								--unit name
	type = "F-5E-3",								--aircraft type
	helicopter = true,								--true for helicopter units
	country = "USA",								--unit country
	livery = {"USAF Euro Camo"},					--unit livery
	base = "Groom Lake AFB",						--unit base
	skill = "Random",								--unit skill
	tasks = {										--list of eligible unit tasks. Note: task names do not necessary match DCS tasks)
		["AWACS"] = true,							
		["Anti-ship Strike"] = true,
		["CAP"] = true,
		["Fighter Sweep"] = true,	
		["Intercept"] = true,
		["Reconnaissance"] = true,
		["Refueling"] = true,
		["Strike"] = true,							--Generic air-ground task (replaces "Ground Attack", "CAS" and "Pinpoint Strike")
		["Transport"] = true,
		["Escort"] = true,							--Support task: Fighter escort for package
		["SEAD"] = true,							--Support task: SEAD escort for package
		["Escort Jammer"] = true,					--Support task: Single airraft in center of package for defensive jamming
		["Flare Illumination"] = true,				--Support task: Illuminate target with flares for package
		["Laser Illumination"] = true,				--Support task: Lase target for package
		["Stand-Off Jammer"] = true,				--Not implemeted yet: On-station jamming
		["Chaff Escort"] = true,					--Not implemented yet: Lay chaff corrdior ahead of package
		["A-FAC"] = true,							--Not implemented yet: Airborne forward air controller
	},
	number = 12,									--number of airframes
},

]]-----------------------------------------------------------------------------------------------------

oob_air = {
	["blue"] = {											--side 1
		{
			name = "11th Attack Squadron",								--unit name
			inactive = true,								--true if unit is not active
			player = false,									--player unit
			type = "MQ-9 Reaper",								--aircraft type
			country = "USA",								--unit country
			livery = {""},	--unit livery
			base = "Larnaca",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["AFAC"] = true,
				["Strike"] = false,
				["Anti-ship Strike"] = false,
				["Laser Illumination"] = false,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 2,
				["AFAC"] = 3,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 0.5,
			},
			number = 4,
			reserve = 18,
		},
		{
			name = "74th FS",								--unit name
			inactive = true,								--true if unit is not active
			player = false,									--player unit
			type = "A-10C_2",								--aircraft type
			country = "USA",								--unit country
			livery = {"74th fs moody afb, georgia (ft)"},	--unit livery
			base = "Larnaca",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = true,
				["Anti-ship Strike"] = false,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 0.5,
			},
			number = 4,
			reserve = 18,
		},
		{
			name = "47th FS",								--unit name
			inactive = true,								--true if unit is not active
			player = false,									--player unit
			type = "A-10C",								--aircraft type
			country = "USA",								--unit country
			livery = {"47th FS Barksdale AFB, Louisiana (BD)"},	--unit livery
			base = "Larnaca",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = true,
				["Anti-ship Strike"] = false,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 3,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 0.5,
			},
			number = 2,
			reserve = 18,
		},
		{
			name = "Avengers 1-227th ARB",	--unit name
			player = false,									--player unit
			inactive = true,
			type = "AH-64D_BLK_II",								--aircraft type
			helicopter = true,
			country = "USA",								--unit country
			livery = {"Avengers 1-227th ARB"},					--unit livery
			base = "Beirut-Rafic Hariri",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = true,
				["Fighter Sweep"] = false,
				["Strike"] = true,
				["Anti-ship Strike"] = false,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
			},
			number = 6,
			reserve = 24,
		},
		{
			name = "4eme RHA",								--unit name
			inactive = true,								--true if unit is not active
			player = false,									--player unit
			type = "SA342M",								--aircraft type
			helicopter = true,
			country = "France",								--unit country
			livery = {"Desert Storm FR Sand"},				--unit livery		https://www.digitalcombatsimulator.com/en/files/1948642/
			base = "Beirut-Rafic Hariri",								--unit base
			skill = "high",								--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,				
			},
			number = 4,
			reserve = 32,
		},	
		{
			name = "8th Squadron",								--unit name
			inactive = false,								--true if unit is not active
			player = false,									--player unit
			type = "SA342L",								--aircraft type
			helicopter = true,
			country = "Lebanon",								--unit country
			livery = {"leb air force gg"},										--unit livery
			base = "Beirut-Rafic Hariri",								--unit base
			skill = "high",								--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,				
			},
			number = 2,
			reserve = 24,
		},
		{
			name = "US Army 1-6 A",
			player = false,
			inactive = false,
			type = "OH58D",
			helicopter = true,
			country = "USA",
			livery = {"us 1-6 a 340"},
			base = "Beirut-Rafic Hariri",
			skill = "High",
			tasks = {
				CAP = false,
				Escort = true,
				["Fighter Sweep"] = false,
				Strike = true,
				["Anti-ship Strike"] = false,
				["SAR"] = false,
				["CSAR"] = false,
			},--A 4 3
			tasksCoef = {
				Strike = 2,
				SEAD = 1,
				["Laser Illumination"] = 1,
				Intercept = 1,
				CAP = 1,
				Escort = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 3,
				["SAR"] = 1,
				["CSAR"] = 2,
			},--A 4 3
			number = 4,
			reserve = 12,
		},
		{
			name = "Cyprus Attack Helicopter Sqd",	--unit name
			player = false,									--player unit
			inactive = true,
			type = "Ka-50",								--aircraft type
			helicopter = true,
			country = "Greece",								--unit country
			livery = {"Hellenic Army - Desert camo"},					--unit livery   https://www.digitalcombatsimulator.com/fr/files/3329602/
			base = "Beirut-Rafic Hariri",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = true,
				["Fighter Sweep"] = false,
				["Strike"] = true,
				["Anti-ship Strike"] = false,
				["SAR"] = false,
				["CSAR"] = false,
			},	
			number = 2,
			reserve = 10,
		},	
		{
			name = "Georgian Attack Helicopter Squadron",	--unit name
			player = false,									--player unit
			inactive = true,
			type = "Mi-24P",								--aircraft type
			helicopter = true,
			country = "Georgia",								--unit country
			livery = {"Georgian Air Force"},					--unit livery
			base = "Beirut-Rafic Hariri",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = true,
				["Fighter Sweep"] = false,
				["Strike"] = true,
				["Anti-ship Strike"] = false,
				["SAR"] = false,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 3,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 1,
				["CSAR"] = 2,
			},
			number = 4,
			reserve = 12,
		},
		{
			name = "Georgian SAR Helicopter Squadron",	--unit name
			player = false,									--player unit
			inactive = false,
			type = "Mi-8MT",								--aircraft type
			helicopter = true,
			country = "Georgia",								--unit country
			livery = {"Georgian Standard"},					--unit livery
			base = "Akrotiri",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = false,
				["Anti-ship Strike"] = false,
				["SAR"] = true,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 2,
				["CSAR"] = 2,
			},
			number = 4,
			reserve = 12,
		},
		{
			name = "EC 1-2",								--unit name
			inactive = false,								--true if unit is not active
			player = false,									--player unit
			type = "M-2000C",								--aircraft type
			country = "France",								--unit country
			livery = {"AdA Chasse 1-2 EF", "AdA Chasse 1-2 EL", "AdA Chasse 1-2 ET", "AdA Chasse 1-2 EV", "AdA Chasse 1-2 EW", "AdA Chasse 1-2 EY", "AdA Chasse 1-2 FZ", "AdA Chasse 1-2 MK"},		--unit livery https://www.digitalcombatsimulator.com/fr/files/3315817/
			base = "Paphos",							--unit base
			parking_id = {
                [""] = {27,37},
            },
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Strike"] = false,
				["Intercept"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 0.4,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 1.5,
				["Escort"] = 1.2,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
			},
			number = 8,
			reserve = 30,
		},
		{
			name = "EC 1-33",								--unit name
			inactive = true,								--true if unit is not active
			player = false,									--player unit
			type = "Mirage-F1EE",								--aircraft type
			country = "France",								--unit country
			livery = {"33-CH 1-33 Belfort 2007", "33-CF 1-33 Belfort 2007"},	--unit livery   https://www.digitalcombatsimulator.com/en/files/3325557/
			base = "Paphos",							--unit base
			parking_id = {
                [""] = {23,26},
            },
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = false,
				["Intercept"] = true,
				["Reconnaissance"] = false,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 3,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["Reconnaissance"] = 2,
			},
			number = 4,
			reserve = 30,
		},
		{
			name = "58 TFS",								--unit name
			inactive = false,								--true if unit is not active
			player = false,									--player unit
			type = "F-15C",									--aircraft type
			country = "USA",								--unit country
			livery = "58th Fighter SQN (EG)",				--unit livery
			base = "Incirlik",						--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Intercept"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 2,
				["Escort"] = 1.5,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
			},
			number = 8,
			reserve = 18,
		},
		{
			name = "111 Filo",
			inactive = false,
			player = false,
			type = "F-4E-45MC",
			country = "Turkey",
			livery = {"TUAF-68-0342-H2"},
			base = "Akrotiri",
			skill = "High",
			tasks = {
				Intercept = false,
				Strike = true,
				SEAD = false,
				CAP = false,
				Escort = false,
				["Fighter Sweep"] = false,
			},--A 4 3
			tasksCoef = {
				Strike = 1,
				SEAD = 1,
				["Laser Illumination"] = 1,
				Intercept = 1,
				CAP = 1,
				Escort = 1,
				["Fighter Sweep"] = 1,
			},--A 4 3
			number = 12,
			reserve = 24,
		},
		{
			name = "335 TFS",								--unit name
			inactive = true,								--true if unit is not active
			player = false,									--player unit
			type = "F-15ESE",									--aircraft type
			country = "USA",								--unit country
			livery = "USAF 335th Chiefs FS AF89 Low Vis Combat",				--unit livery
			base = "Incirlik",						--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
				["Runway Attack"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["Runway Attack"] = 1,
			},
			number = 4,
			reserve = 18,
		},
		{
			name = "77 TFS-SEAD",								--unit name
			inactive = false,								--true if unit is not active
			player = false,									--player unit
			type = "F-16C_50",							--aircraft type
			country = "USA",								--unit country
			livery = "77th_Fighter_Squadron",			--unit livery
			base = "Akrotiri",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = false,
				["SEAD"] = true,
				["Laser Illumination"] = false,
				["Intercept"] = false,
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,	
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1.5,								-- coef normal : = 1
				["SEAD"] = 2,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1.5,
				["Escort"] = 1,
				["Fighter Sweep"] = 0.2,
				["Anti-ship Strike"] = 1,
			},
			number = 16,
			reserve = 24,
		},
		{
			name = "13 TFS",								--unit name
			inactive = false,								--true if unit is not active
			player = false,									--player unit
			type = "F-16C_50",							--aircraft type
			country = "USA",								--unit country
			livery = "13th_Fighter_Squadron",			--unit livery
			base = "Akrotiri",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
				["SEAD"] = true,
				["Laser Illumination"] = true,
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Runway Attack"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1.5,								-- coef normal : = 1
				["SEAD"] = 2,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1.5,
				["Escort"] = 1,
				["Fighter Sweep"] = 0.2,
				["Anti-ship Strike"] = 1,
				["Runway Attack"] = 1,
			},
			number = 8,
			reserve = 26,
		},
		{
			name = "VFA-106",								--unit name
			inactive = false,								--true if unit is not active
			player = true,									--player unit TESTING
			type = "FA-18C_hornet",							--aircraft type
			country = "USA",								--unit country
			livery = "vfa-106",								--unit livery	livery = "VFA-131",
			liveryModex = {									--unit livery Modex  (optional)
				[200] = "vfa-106 high visibility",
				},
			sidenumber = {200, 215},														 
			base = "CVN-71 Theodore Roosevelt",				--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["SEAD"] = true,
				["Intercept"] = true,
				["CAP"] = true,
				["Fighter Sweep"] = false,
				["Escort"] = true,
				["Strike"] = true,
				["Anti-ship Strike"] = true,
				["Runway Attack"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2.5,								-- coef normal : = 1
				["SEAD"] = 2,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 0.2,
				["Escort"] = 0.5,
				["Fighter Sweep"] = 0.1,
				["Anti-ship Strike"] = 2,
				["Runway Attack"] = 1,
			},
			number = 12,
			reserve = 34,
		},
		{
			name = "7 ACCS",								--unit name
			inactive = false,								--true if unit is not active
			type = "E-3A",									--aircraft type
			country = "USA",								--unit country
			livery = "usaf standard",						--unit livery
			base = "Incirlik",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["AWACS"] = true,
			},
			number = 3,
			reserve = 2,
		},
		{
			name = "171 ARW",								--unit name
			inactive = false,								--true if unit is not active
			type = "KC135MPRS",								--aircraft type
			country = "USA",								--unit country
			livery = "",									--unit livery
			base = "Akrotiri",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Refueling"] = true,
			},
			number = 4,
			reserve = 9,
		},
		{
			name = "801 ARS",								--unit name
			inactive = false,								--true if unit is not active
			type = "KC-135",								--aircraft type
			country = "USA",								--unit country
			livery = "Standard USAF",						--unit livery
			base = "Incirlik",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Refueling"] = true,
			},
			number = 4,
			reserve = 6,
		},
		{
			name = "174 ARW",								--unit name
			inactive = false,								--true if unit is not active
			type = "KC135MPRS",								--aircraft type
			country = "USA",								--unit country
			livery = "",									--unit livery
			base = "Incirlik",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Refueling"] = true,
			},
			number = 4,
			reserve = 6,
		},
		{
			name = "VF-101",							--unit name
			inactive = false,								--true if unit is not active
			player = false,									--player unit TESTING
			type = "F-14B",								--aircraft type
			country = "USA",								--unit country
			livery = {"vf-101 grim reapers low vis", "vf-101 dark"},				--unit livery
			liveryModex = {									--unit livery Modex  (optional)
				[100] = "vf-101 red",
				[105] = "vf-101 grim reapers low vis",
				[111] = "vf-101 dark",
				},
			sidenumber = {100, 115},														 
			base = "CVN-75 Harry S. Truman",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Strike"] = false,
				["Runway Attack"] = false,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 4,
				["CAP"] = 2,
				["Escort"] = 3,
				["Fighter Sweep"] = 1,
				["Runway Attack"] = 1,
			},
			number = 12,
			reserve = 34,
		},
		{
			name = "VMA 311",								--unit name
			inactive = false,								--true if unit is not active
			player = false,									--player unit
			type = "AV8BNA",								--aircraft type
			country = "USA",								--unit country
			livery = "vma-311",								--unit livery
			liveryModex = {									--unit livery Modex  (optional)
				[100] = "vma-311d",
				},
			sidenumber = {100, 103},
			base = "LHA_Tarawa",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
				["SEAD"] = false,
				["Runway Attack"] = true,
			},
			number = 4,
			reserve = 30,
		},
		{
			name = "F7",								--unit name
			inactive = true,								--true if unit is not active
			player = false,									--player unit
			type = "AJS37",								--aircraft type
			country = "Sweden",								--unit country
			livery = {"#4 Splinter F7 Skaraborgs Flygflottilj 76"},					--unit livery
			base = "Larnaca",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = true,
				["Anti-ship Strike"] = true,
				["Runway Attack"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 3,
				["Runway Attack"] = 2,
			},
			number = 4,
			reserve = 30,
		},
		{
			name = "VAW-125",								--unit name
			inactive = false,								--true if unit is not active
			type = "E-2C",									--aircraft type
			country = "USA",								--unit country
			livery = "",									--unit livery
			sidenumber = {600, 609},						--unit range of sidenumbers (optional)
			base = "CVN-71 Theodore Roosevelt",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["AWACS"] = true,
			},
			number = 8,
			reserve = 2,
		},
		{
			name = "174 ARW",								--unit name
			inactive = true,								--true if unit is not active
			type = "S-3B Tanker",								--aircraft type
			country = "USA",								--unit country
			livery = "",									--unit livery
			sidenumber = {400, 429},						--unit range of sidenumbers (optional)
			base = "CVN-71 Theodore Roosevelt",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Refueling"] = true,
			},
			number = 12,
			reserve = 10,
		},
		{
			inactive = true,								--true if unit is not active		
			name = "96 BW",								--unit name
			type = "B-1B",								--aircraft type
			country = "USA",								--unit country
			livery = "Standard USAF",						--unit livery
			base = "Dyess AFB",							--unit base
			skill = "High",								--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
			},
			number = 4,
			reserve = 16,
		},
		{
			inactive = false,								--true if unit is not active
			name = "69 BS",									--unit name
			type = "B-52H",									--aircraft type
			country = "USA",								--unit country
			livery = "usaf standard",						--unit livery
			sidenumber = {020, 050},						--unit range of sidenumbers (optional)
			base = "Dyess AFB",								--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
			},
			number = 4,
			reserve = 16,
		},
		{
			name = "HSL-33 Det 1",								--unit name
			inactive = false,								--true if unit is not active
			type = "SH-60B",								--aircraft type
			helicopter = true,
			country = "USA",								--unit country
			livery = "",									--unit livery
			sidenumber = {700, 705},						--unit range of sidenumbers (optional)
			base = "CVN-71 Theodore Roosevelt",				--unit base base = "CVN-71 Theodore Roosevelt",	
			skill = "Excellent",								--unit skill
			tasks = {										--unit tasks
				["SAR"] = true,
				["CSAR"] = true,
			},
			number = 4,
			reserve = 10,
		},
		{
			name = "HSL-33 Det 2",								--unit name
			inactive = false,								--true if unit is not active
			type = "SH-60B",								--aircraft type
			helicopter = true,
			country = "USA",								--unit country
			livery = "",									--unit livery
			sidenumber = {900, 905},						--unit range of sidenumbers (optional)
			base = "LHA_Tarawa",				--unit base base = "CVN-71 Theodore Roosevelt",	
			skill = "Excellent",								--unit skill
			tasks = {										--unit tasks
				["SAR"] = true,
				["CSAR"] = true,
			},
			number = 4,
			reserve = 10,
		},
		-- {
			-- name = "HSL-33 Det 3",								--unit name
			-- inactive = false,								--true if unit is not active
			-- type = "SH-60B",								--aircraft type
			-- helicopter = true,
			-- country = "USA",								--unit country
			-- livery = "",									--unit livery
			-- sidenumber = {900, 905},						--unit range of sidenumbers (optional)
			-- base = "LHA_Nassau",				--unit base base = "CVN-71 Theodore Roosevelt",	
			-- skill = "Excellent",								--unit skill
			-- tasks = {										--unit tasks
				-- ["SAR"] = true,
				-- ["CSAR"] = true,
			-- },
			-- number = 4,
			-- reserve = 10,
		-- },
		{
			name = "HSL-33 Det 1-1",								--unit name
			inactive = true,								--true if unit is not active
			type = "UH-60L",								--aircraft type
			helicopter = true,
			country = "USA",								--unit country
			livery = "US Navy Grey",									--unit livery
			sidenumber = {700, 705},						--unit range of sidenumbers (optional)
			base = "CVN-71 Theodore Roosevelt",				--unit base base = "CVN-71 Theodore Roosevelt",	
			skill = "Excellent",								--unit skill
			tasks = {										--unit tasks
				["SAR"] = true,
				["CSAR"] = true,
			},
			number = 4,
			reserve = 10,
		},
		{
			name = "HSL-33 Det 2-1",								--unit name
			inactive = true,								--true if unit is not active
			type = "UH-60L",								--aircraft type
			helicopter = true,
			country = "USA",								--unit country
			livery = "US Navy Grey",									--unit livery
			sidenumber = {900, 905},						--unit range of sidenumbers (optional)
			base = "LHA_Tarawa",				--unit base base = "CVN-71 Theodore Roosevelt",	
			skill = "Excellent",								--unit skill
			tasks = {										--unit tasks
				["SAR"] = true,
				["CSAR"] = true,
			},
			number = 4,
			reserve = 10,
		},
		-- {
			-- name = "HSL-33 Det 3-1",								--unit name
			-- inactive = true,								--true if unit is not active
			-- type = "UH-60L",								--aircraft type
			-- helicopter = true,
			-- country = "USA",								--unit country
			-- livery = "US Navy Grey",									--unit livery
			-- sidenumber = {900, 905},						--unit range of sidenumbers (optional)
			-- base = "LHA_Nassau",				--unit base base = "CVN-71 Theodore Roosevelt",	
			-- skill = "Excellent",								--unit skill
			-- tasks = {										--unit tasks
				-- ["SAR"] = true,
				-- ["CSAR"] = true,
			-- },
			-- number = 4,
			-- reserve = 10,
		-- },
		{
			name = "160th SOAR Det 1",								--unit name
			inactive = false,								--true if unit is not active
			type = "UH-1H",								--aircraft type
			helicopter = true,
			country = "USA",								--unit country
			livery = "",									--unit livery
			sidenumber = {900, 905},						--unit range of sidenumbers (optional)
			base = "Incirlik",				--unit base base = "CVN-71 Theodore Roosevelt",	
			skill = "Excellent",								--unit skill
			tasks = {										--unit tasks
				["SAR"] = true,
				["CSAR"] = true,
			},
			number = 4,
			reserve = 10,
		},
		{
			name = "160th SOAR Det 2",								--unit name
			inactive = false,								--true if unit is not active
			type = "UH-1H",								--aircraft type
			helicopter = true,
			country = "USA",								--unit country
			livery = "",									--unit livery
			sidenumber = {900, 905},						--unit range of sidenumbers (optional)
			base = "Larnaca",				--unit base base = "CVN-71 Theodore Roosevelt",	
			skill = "Excellent",								--unit skill
			tasks = {										--unit tasks
				["SAR"] = true,
				["CSAR"] = true,
			},
			number = 4,
			reserve = 10,
		},
		{
			name = "160th SOAR Det 3",								--unit name
			inactive = false,								--true if unit is not active
			type = "UH-1H",								--aircraft type
			helicopter = true,
			country = "USA",								--unit country
			livery = "",									--unit livery
			sidenumber = {900, 905},						--unit range of sidenumbers (optional)
			base = "Akrotiri",				 				--unit base 
			skill = "Excellent",								--unit skill
			tasks = {										--unit tasks
				["SAR"] = true,
				["CSAR"] = true,
			},
			number = 4,
			reserve = 10,
		},
		{
			name = "160th SOAR Det 4",								--unit name
			inactive = false,								--true if unit is not active
			type = "UH-1H",								--aircraft type
			helicopter = true,
			country = "USA",								--unit country
			livery = "",									--unit livery
			sidenumber = {900, 905},						--unit range of sidenumbers (optional)
			base = "Hatay",									--unit base 
			skill = "Excellent",								--unit skill
			tasks = {										--unit tasks
				["SAR"] = true,
				["CSAR"] = true,
			},
			number = 4,
			reserve = 10,
		},
		{
			name = "160th SOAR Det 1-1",								--unit name
			inactive = true,								--true if unit is not active
			type = "UH-60L",								--aircraft type
			helicopter = true,
			country = "USA",								--unit country
			livery = "",									--unit livery
			sidenumber = {900, 905},						--unit range of sidenumbers (optional)
			base = "Incirlik",								--unit base 
			skill = "Excellent",								--unit skill
			tasks = {										--unit tasks
				["SAR"] = true,
				["CSAR"] = true,
			},
			number = 4,
			reserve = 10,
		},
		{
			name = "160th SOAR Det 2-1",								--unit name
			inactive = true,								--true if unit is not active
			type = "UH-60L",								--aircraft type
			helicopter = true,
			country = "USA",								--unit country
			livery = "",									--unit livery
			sidenumber = {900, 905},						--unit range of sidenumbers (optional)
			base = "Larnaca",								--unit base 
			skill = "Excellent",								--unit skill
			tasks = {										--unit tasks
				["SAR"] = true,
				["CSAR"] = true,
			},
			number = 4,
			reserve = 10,
		},
		{
			name = "160th SOAR Det 3-1",								--unit name
			inactive = true,								--true if unit is not active
			type = "UH-60L",								--aircraft type
			helicopter = true,
			country = "USA",								--unit country
			livery = "",									--unit livery
			sidenumber = {900, 905},						--unit range of sidenumbers (optional)
			base = "Akrotiri",								--unit base 
			skill = "Excellent",								--unit skill
			tasks = {										--unit tasks
				["SAR"] = true,
				["CSAR"] = true,
			},
			number = 4,
			reserve = 10,
		},
		{
			name = "Beirut SOAR Det 1",								--unit name
			inactive = false,								--true if unit is not active
			type = "UH-1H",								--aircraft type
			helicopter = true,
			country = "CJTF Blue",								--unit country
			livery = {"Olive drab"},
			base = "Beirut-Rafic Hariri",				--unit base 
			skill = "Excellent",								--unit skill
			tasks = {										--unit tasks
				["SAR"] = true,
				["CSAR"] = true,
			},
			number = 4,
			reserve = 10,
		},
		{
			name = "136th AW",								--unit name
			player = false,									--player unit
			inactive = true,
			type = "C-130",									--aircraft type
			country = "USA",								--unit country
			livery = "US Air Force",						--unit livery 
			base = "Larnaca",								--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks				
				["Transport"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 2,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
			},
			number = 4,
			reserve = 18,
		},
		{
			name = "86th AW",								--unit name
			player = false,									--player unit
			inactive = true,
			type = "Hercules",									--aircraft type
			country = "USA",								--unit country
			livery = "86th AW Ramstein AB V2.0",				--unit livery  https://www.digitalcombatsimulator.com/en/files/3313170/
			base = "Larnaca",						--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["Transport"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 2,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
			},
			number = 2,
			reserve = 18,
		},
	},	
	["red"] = {												--side 2
		{
			name = "1st Syrian SAR",	--unit name
			player = false,									--player unit
			inactive = false,
			type = "Mi-8MT",								--aircraft type
			helicopter = true,
			country = "Syria",								--unit country
			livery = {""},					--unit livery
			base = "Taftanaz",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = false,
				["Anti-ship Strike"] = false,
				["SAR"] = true,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 2,
				["CSAR"] = 2,
			},
			number = 2,
			reserve = 12,
		},
		{
			name = "2nd Syrian SAR",	--unit name
			player = false,									--player unit
			inactive = false,
			type = "Mi-8MT",								--aircraft type
			helicopter = true,
			country = "Syria",								--unit country
			livery = {""},					--unit livery
			base = "Rene Mouawad",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = false,
				["Anti-ship Strike"] = false,
				["SAR"] = true,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 2,
				["CSAR"] = 2,
			},
			number = 2,
			reserve = 12,
		},
		{
			name = "3rd Syrian SAR",	--unit name
			player = false,									--player unit
			inactive = false,
			type = "Mi-8MT",								--aircraft type
			helicopter = true,
			country = "Syria",								--unit country
			livery = {""},					--unit livery
			base = "Tha\'lah",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = false,
				["Anti-ship Strike"] = false,
				["SAR"] = true,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 2,
				["CSAR"] = 2,
			},
			number = 2,
			reserve = 12,
		},
		{
			name = "1st Syrian Attack Helicopter Rgt",	--unit name
			player = false,									--player unit
			inactive = true,
			type = "Mi-24P",								--aircraft type
			helicopter = true,
			country = "Syria",								--unit country
			livery = {"Syrian Arab Republic AF"},					--unit livery  https://www.digitalcombatsimulator.com/fr/files/3320614/
			base = "Qabr as Sitt",							--unit base
			baseAlternative = {"Qabr as Sitt", "Mezzeh"},
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = true,
				["Fighter Sweep"] = false,
				["Strike"] = true,
				["Anti-ship Strike"] = false,
				["SAR"] = false,
				["CSAR"] = false,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 3,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 1,
				["CSAR"] = 1,
			},
			number = 4,
			reserve = 12,
		},
		{
			name = "2nd Syrian Attack Helicopter Rgt",	--unit name
			player = false,									--player unit
			inactive = false,
			type = "Mi-24P",								--aircraft type
			helicopter = true,
			country = "Syria",								--unit country
			livery = {"Syrian Arab Republic AF"},					--unit livery  https://www.digitalcombatsimulator.com/fr/files/3320614/
			base = "Wujah Al Hajar",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = true,
				["Fighter Sweep"] = false,
				["Strike"] = true,
				["Anti-ship Strike"] = false,
				["SAR"] = false,
				["CSAR"] = false,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 3,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 1,
				["CSAR"] = 1,
			},
			number = 4,
			reserve = 12,
		},
		{
			name = "3rd Syrian Attack Helicopter Rgt",	--unit name
			player = false,									--player unit
			inactive = true,
			type = "Mi-24P",								--aircraft type
			helicopter = true,
			country = "Syria",								--unit country
			livery = {"Syrian Arab Republic AF"},			--unit livery  https://www.digitalcombatsimulator.com/fr/files/3320614/
			base = "Mezzeh",							--unit base
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = true,
				["Fighter Sweep"] = false,
				["Strike"] = true,
				["Anti-ship Strike"] = false,
				["SAR"] = false,
				["CSAR"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 3,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1,
				["SAR"] = 1,
				["CSAR"] = 1,
			},
			number = 4,
			reserve = 12,
		},
		{
			name = "825 Squadron",							--unit name
			inactive = true,								--true if unit is not active
			type = "MiG-21Bis",								--aircraft type
			country = "Syria",								--unit country
			livery = {"Syria (1)"},							--unit livery	
			base = "Abu al-Duhur",								--unit base
			skill = "Random",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Strike"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 1,
				["Escort"] = 1.5,
				["Fighter Sweep"] = 1,	
			},
			number = 6,
			reserve = 24,
		},		
		{
			name = "679 Squadron",							--unit name
			inactive = true,								--true if unit is not active
			type = "MiG-21Bis",								--aircraft type
			country = "Syria",								--unit country
			livery = {"Syria (1)"},							--unit livery 	
			base = "Bassel Al-Assad",								--unit base
			skill = "Random",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Strike"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 1,
				["Escort"] = 1.5,
				["Fighter Sweep"] = 1,	
			},
			number = 6,
			reserve = 24,
		},
		{
			name = "12 Squadron",							--unit name
			inactive = false,								--true if unit is not active
			type = "MiG-21Bis",								--aircraft type
			country = "Syria",								--unit country
			livery = {"Syria (2)"},						--unit livery 	
			base = "An Nasiriyah",							--unit base
			skill = "Random",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Strike"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 1,
				["Escort"] = 1.5,
				["Fighter Sweep"] = 1,	
			},
			number = 6,
			reserve = 24,
		},
		{
			name = "5 Squadron",								--unit name
			inactive = false,								--true if unit is not active
			type = "MiG-25PD",								--aircraft type
			country = "Syria",								--unit country
			livery = "Syrian Air Force",							--unit livery  https://www.digitalcombatsimulator.com/en/files/3316403/
			base = "Tiyas",							--unit base
			skill = "Random",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 1.5,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,	
			},
			number = 4,
			reserve = 6,
		},
		{
			name = "54 Squadron",							--unit name
			inactive = false,								--true if unit is not active
			type = "MiG-23MLD",								--aircraft type
			country = "Syria",							--unit country
			livery = "SAAF",						--unit livery      https://www.digitalcombatsimulator.com/en/files/3312157/
			base = "Shayrat",							--unit base
			skill = "Random",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Strike"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1.5,
				["CAP"] = 1,
				["Escort"] = 2,
				["Fighter Sweep"] = 1,	
			},
			number = 12,
			reserve = 24,
		},
		{
			name = "67 Squadron",							--unit name
			inactive = true,								--true if unit is not active
			type = "MiG-23MLD",								--aircraft type
			country = "Syria",							--unit country
			livery = "SAAF",						--unit livery					https://www.digitalcombatsimulator.com/en/files/3312157/
			base = "Aleppo",							--unit base
			skill = "Random",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,
				["Strike"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1.5,
				["CAP"] = 1,
				["Escort"] = 2,
				["Fighter Sweep"] = 1,	
			},
			number = 8,
			reserve = 24,			
		},
		{
			name = "2 Squadron",								--unit name
			inactive = false,								--true if unit is not active
			type = "L-39ZA",								--aircraft type
			country = "Syria",								--unit country
			livery = {"Syrian 2055", "Syrian 2092", "Syrian 2099", "Syrian 2172"},						--unit livery
			base = "Rayak",						--unit base
			skill = "Random",
			tasks = {
				["Strike"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2,								-- coef normal : = 1
				["SEAD"] = 1.5,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,	
			},
			number = 8,
			reserve = 24,
		},
		{
			name = "699 Squadron",								--unit name
			inactive = true,								--true if unit is not active
			type = "MiG-29A",								--aircraft type
			country = "Syria",						--unit country
			livery = "SaAF 689 Squadron",			--unit livery
			base = "Al-Dumayr",							--unit base
			skill = "Random",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,				
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 1.5,
				["Escort"] = 1,
				["Fighter Sweep"] = 1.5,	
			},
			number = 12,
			reserve = 24,
		},
		{
			name = "677 Squadron",								--unit name
			inactive = false,								--true if unit is not active
			type = "Su-17M4",								--aircraft type
			country = "Syria",								--unit country
			livery = "SAAF",								--unit livery  https://www.digitalcombatsimulator.com/en/files/3314373/
			base = "Damascus",						--unit base
			baseAlternative = {"Damascus", "Al-Dumayr"},
			skill = "high",								--unit skill
			tasks = {
				["Strike"] = true,
				["SEAD"] = false,
				["Laser Illumination"] = false,
				["Anti-ship Strike"] = false,
				["Runway Attack"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1.5,
				["Runway Attack"] = 1,
			},
			number = 6,
			reserve = 36,
		},
		{
			name = "685 Squadron",								--unit name
			inactive = true,								--true if unit is not active
			type = "Su-17M4",								--aircraft type
			country = "Syria",								--unit country								--unit country
			livery = {"SAAF"},						--unit livery     https://www.digitalcombatsimulator.com/en/files/3314373/
			base = "Mezzeh",								--unit base
			skill = "high",								--unit skill
			tasks = {										--unit tasks
				["Strike"] = true,
				["Anti-ship Strike"] = true,
				["SEAD"] = false,
				["Runway Attack"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1.5,
				["Runway Attack"] = 1,
			},
			number = 6,
			reserve = 18,
		},
		{
			name = "819 Squadron",								--unit name
			inactive = false,								--true if unit is not active
			type = "Su-24M",								--aircraft type
			country = "Syria",								--unit country
			livery = "819 Squadron",								--unit livery
			base = "Damascus",						--unit base
			baseAlternative = {"Damascus", "Al-Dumayr"},
			skill = "high",								--unit skill
			tasks = {
				["Strike"] = true,
				["SEAD"] = true,
				["Anti-ship Strike"] = true,
				["Runway Attack"] = true,
				
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 2,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 1,
				["CAP"] = 1,
				["Escort"] = 1,
				["Fighter Sweep"] = 1,
				["Anti-ship Strike"] = 1.5,
				["Runway Attack"] = 1,
			},
			number = 12,
			reserve = 36,
		},
		{
			name = "28 GvIAP",								--unit name
			inactive = true,								--true if unit is not active
			type = "MiG-29S",								--aircraft type
			country = "Russia",						--unit country
			livery = "28 GvIAP_Andreapol",			--unit livery
			base = "Al-Dumayr",							--unit base
			skill = "high",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = true,				
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 1.5,
				["Escort"] = 1,
				["Fighter Sweep"] = 1.5,	
			},
			number = 6,
			reserve = 24,
		},
		{
			name = "277th Bomber Aviation Regiment",								--unit name
			inactive = true,								--true if unit is not active
			type = "Su-34",								--aircraft type
			country = "Russia",						--unit country
			livery = "Russian Air Force",			--unit livery
			base = "Al-Dumayr",							--unit base
			baseAlternative = {"Al-Dumayr", "Tiyas", "Palmyra"},
			skill = "high",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = false,
				["CAP"] = false,
				["Escort"] = false,
				["Fighter Sweep"] = false,
				["Strike"] = true,								
				["SEAD"] = true,
				["Anti-ship Strike"] = false,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 1.5,
				["Escort"] = 1,
				["Fighter Sweep"] = 1.5,	
			},
			number = 6,
			reserve = 24,
		},
		{
			name = "14th IAP",								--unit name
			inactive = true,								--true if unit is not active
			type = "Su-30",								--aircraft type
			country = "Russia",						--unit country
			livery = "af standard early (worn-out)",			--unit livery
			base = "Al-Dumayr",							--unit base
			baseAlternative = {"Al-Dumayr", "Tiyas", "Palmyra"},
			skill = "high",								--unit skill
			tasks = {										--unit tasks
				["Intercept"] = true,
				["CAP"] = true,
				["Escort"] = true,
				["Fighter Sweep"] = false,
				["Strike"] = true,								
				["SEAD"] = true,
				["Anti-ship Strike"] = true,
			},
			tasksCoef = {									--unit tasks coef (optional)
				["Strike"] = 1,								-- coef normal : = 1
				["SEAD"] = 1,
				["Laser Illumination"] = 1,
				["Intercept"] = 2,
				["CAP"] = 1.5,
				["Escort"] = 1,
				["Fighter Sweep"] = 1.5,	
			},
			number = 4,
			reserve = 24,
		},
		{
			name = "Russian Attack Helicopter Rgt",	--unit name
			player = false,									--player unit
			inactive = true,
			type = "Ka-50_3",								--aircraft type
			helicopter = true,
			country = "Russia",								--unit country
			livery = {""},					--unit livery  
			base = "Qabr as Sitt",							--unit base
			baseAlternative = {"Qabr as Sitt", "Mezzeh"},
			skill = "High",									--unit skill
			tasks = {										--unit tasks
				["CAP"] = false,
				["Escort"] = true,
				["Fighter Sweep"] = false,
				["Strike"] = true,
				["Anti-ship Strike"] = false,
				["SAR"] = false,
				["CSAR"] = false,
			},	
			number = 4,
			reserve = 10,
		},
	},
}

--List of aliases to replace type names in briefing/debriefing
TypeAlias = {
["Mi-24P"] = "Mi-35",
["Su-17M4"] = "Su-22M-4",
["M-2000C"] = "M-2000-5F",
}






